
uniform sampler2D uni_is_tex ;

/// The reciprocal width of the incomming texture.
uniform float uni_f_recip_width ;
uniform float uni_f_recip_height ;

const float weight = 1.0 / 24.0 ;

void main()
{
	vec2 step_half = vec2(uni_f_recip_width,uni_f_recip_height) * vec2(0.5) ;
	
	vec4 color = vec4(0) ;

	// inner four
	color += 3.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,-1.0) ) ;
	color += 2.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,1.0) ) ;
	color += 3.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,1.0) ) ;
	color += 2.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,-1.0) ) ;
	
	// top four 
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,3.0) ) ;

	// bottom four

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,-3.0) ) ;

	// left

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,1.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,-1.0) ) ;

	// right

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,1.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,-1.0) ) ;
	

	gl_FragColor = color * vec4(weight) ;
}